/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// OSecDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "OSecDialog.h"

#include "funcheader.h"
#include "section.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COSecDialog dialog


COSecDialog::COSecDialog(CWnd* pParent /*=NULL*/)
	: CDialog(COSecDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(COSecDialog)
	m_oLength = 0.0;
	m_oThickness = 0.0;
	m_oWidth = 0.0;
	m_oExtHeight = 0.0;
	m_check1 = FALSE;
	m_blendRadius = 0.0;
	//}}AFX_DATA_INIT
}


void COSecDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COSecDialog)
	DDX_Text(pDX, IDC_OEDIT1, m_oLength);
	DDX_Text(pDX, IDC_OEDIT2, m_oThickness);
	DDX_Text(pDX, IDC_OEDIT3, m_oWidth);
	DDX_Text(pDX, IDC_OEDIT4, m_oExtHeight);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	DDX_Text(pDX, IDC_OEDIT5, m_blendRadius);
//	DDV_MinMaxDouble(pDX, m_blendRadius, 1.e-004, 1000.);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COSecDialog, CDialog)
	//{{AFX_MSG_MAP(COSecDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COSecDialog message handlers

void COSecDialog::OnOK() 
{
	HRESULT status = CONV_SUCCESS;
	ISet *objset1 = NULL;
	UpdateData(TRUE);
	if(!m_check1)
		m_blendRadius = 0.0;

	if(m_oLength >0 && m_oThickness > 0 && m_oWidth > 0 && m_oExtHeight > 0
		&& m_oThickness < m_oLength && m_oThickness < m_oWidth) {
		
		status = CreateOSection(m_oLength/1000, m_oThickness/1000, m_oWidth/1000, m_oExtHeight/1000,
			m_blendRadius/1000, &objset1);
		if(status != 0|| !objset1){
			AfxMessageBox("CreateOSection failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");
	
	CDialog::OnOK();
}
